!Object constantsFor: 'Geos Libraries'!

geosLIB14 'SYSTEM\config'! !

!Object constantsFor: 'Geos vardata'!

attrPrefRebootString 32768!
attrPrefRequiredFeatures 32772!
attrPrefProhibitedFeatures 32776!
attrPrefMinLevel 32780!
attrPrefMaxLevel 32784!
attrPrefItemGroupEnable 34816!
attrPrefItemGroupOverride 34820!
attrPrefItemGroupTextDisplay 34824!
attrPrefItemGroupStatusText 34828!
attrPrefItemGroupExtraStringSection 34832!
attrPrefTextInitFileCategoryTarget 34816!
attrPrefTriggerAction 27136!
attrPrefValueOrigIsIndeterminate 34816!
attrPrefValueRound 34820!
attrPrefValueWrap 34824!
attrPrefDialogSysShutdownType 35328!
tempPdlKbdData 35328!
attrPrefIniInitFileListCategory 35840!
attrPrefIniInitFileListKey 35844!
attrPrefTocListExtraEntry_1 35840!
attrPrefTocListExtraEntry_2 35844!
attrPrefTocListInfoKey 35848!
attrPrefTocListContainer 35852!
!

!Object constantsFor: 'Geos messages'!

setInitFileCategory 32768!
hasStateChanged 32769!
getRebootInfo 32770!
getRebootString 32771!
init 32772!
notifyDialogChange 32773!
setOriginalState 32774!
booleanGroupSetOriginalState 34816!
itemGroupSetOriginalSelection 34816!
itemGroupGetSelectedItemText 34817!
itemGroupGetItemMoniker 34818!
itemGroupUpdateText 34819!
portItemGetStatus 34816!
portItemFreeDriver 34817!
stringItemSetInitFileString 27136!
stringItemCheckIfInInitFileKey 27137!
valueSetOriginalValue 34816!
closeHandle 35328!
dialogReboot 35328!
dialogConfirmReboot 35329!
dialogRestartAck 35330!
dynamicListBuildArray 35328!
dynamicListFindItem 35329!
dynamicListTimer 35330!
timerTick 35840!
monthChange 35841!
yearChange 35842!
setTime 35843!
setDate 35844!
tocListGetSelectedItemInfo 35840!
tocListGetSelectedDriverName 35841!
tocListGetSelectedItemPath 35842!
tocListCheckDeviceAvailable 35843!
tocListSetTokenChars 35844!
!

!Geos class methodsFor: 'library calls'!

ConfigBuildTitledMoniker: monikerList
	"void pascal ConfigBuildTitledMoniker(optr monikerList) in config.goh"
	^GEOS call: monikerList with: #[14 0 31 2 0]!

ConfigBuildTitledMonikerUsingToken: token with: destBlock
	"ChunkHandle pascal ConfigBuildTitledMonikerUsingToken(GeodeToken *token, MemHandle destBlock) in config.goh"
	^GEOS call: token with: destBlock with: #[14 0 42 3 1 1]!

PrefSaveVideo
	"void pascal PrefSaveVideo(void) in config.goh"
	^GEOS call: #[14 0 15 0]!

PrefRestoreVideo
	"void pascal PrefRestoreVideo(void) in config.goh"
	^GEOS call: #[14 0 16 0]!

PrefDiscardSavedVideo
	"void pascal PrefDiscardSavedVideo(void) in config.goh"
	^GEOS call: #[14 0 17 0]!

TocSortedNameArrayAdd: arr with: nameToAdd with: flags with: data
	"word pascal TocSortedNameArrayAdd(word arr, const char *nameToAdd, NameArrayAddFlags flags, const void *data) in config.goh"
	^GEOS call: arr with: nameToAdd with: flags with: data with: #[14 0 27 1 3 1 3 1]!

TocSortedNameArrayFind: arr with: nameToFind with: flags with: buffer with: elementNum
	"Boolean pascal TocSortedNameArrayFind(word arr, const char *nameToFind, SortedNameArrayFindFlags flags, void *buffer, word *elementNum) in config.goh"
	^GEOS call: arr with: nameToFind with: flags with: buffer with: elementNum with: #[14 0 50 1 3 1 3 3 4]!

TocFindCategory: cat
	"Boolean pascal TocFindCategory(TocCategoryStruct *cat) in config.goh"
	^GEOS call: cat with: #[14 0 32 3 4]!

TocNameArrayFind: array with: name with: buffer
	"word pascal TocNameArrayFind(DBGroupAndItem array, const char *name, void *buffer) in config.goh"
	^GEOS call: array with: name with: buffer with: #[14 0 33 2 3 3 1]!

TocNameArrayGetElement: array with: element with: buffer
	"word pascal TocNameArrayGetElement(DBGroupAndItem array, word element, void *buffer) in config.goh"
	^GEOS call: array with: element with: buffer with: #[14 0 34 2 1 3 1]!

TocUpdateCategory: params
	"void pascal TocUpdateCategory(TocUpdateCategoryParams *params) in config.goh"
	^GEOS call: params with: #[14 0 36 3 0]!

TocNameArrayAdd: array with: nameToFind with: data
	"word pascal TocNameArrayAdd(DBGroupAndItem array, const char *nameToFind, const void *data) in config.goh"
	^GEOS call: array with: nameToFind with: data with: #[14 0 35 2 3 3 1]!

TocDBLock: thing
	"void * pascal TocDBLock(DBGroupAndItem thing) in config.goh"
	^GEOS call: thing with: #[14 0 37 2 3]!

TocDBLockGetRef: thing with: refPtr
	"void * pascal TocDBLockGetRef(DBGroupAndItem thing, optr *refPtr) in config.goh"
	^GEOS call: thing with: refPtr with: #[14 0 38 2 3 3]!

TocAddDisk: diskName with: diskDesc
	"word pascal TocAddDisk(const char *diskName, const TocDiskStruct *diskDesc) in config.goh"
	^GEOS call: diskName with: diskDesc with: #[14 0 39 3 3 1]!

TocCreateNewFile
	"Boolean pascal TocCreateNewFile(void) in config.goh"
	^GEOS call: #[14 0 40 4]!

TocGetFileHandle
	"word pascal TocGetFileHandle() in config.goh"
	^GEOS call: #[14 0 43 1]!

!

Gen subclass: #Pref
	instanceVariableNames: 'pref'
	classVariableNames: ''!

Pref subclass: #PrefBooleanGroup
	instanceVariableNames: ''
	classVariableNames: ''!

Pref subclass: #PrefInteraction
	instanceVariableNames: ''
	classVariableNames: ''!

Pref subclass: #PrefItemGroup
	instanceVariableNames: ''
	classVariableNames: ''!

Pref subclass: #PrefPortItem
	instanceVariableNames: ''
	classVariableNames: ''!

GenItem subclass: #PrefStringItem
	instanceVariableNames: ''
	classVariableNames: ''!

Pref subclass: #PrefText
	instanceVariableNames: ''
	classVariableNames: ''!

GenTrigger subclass: #PrefTrigger
	instanceVariableNames: ''
	classVariableNames: ''!

Pref subclass: #PrefValue
	instanceVariableNames: ''
	classVariableNames: ''!

GenGlyph subclass: #TitledGlyph
	instanceVariableNames: ''
	classVariableNames: ''!

PrefInteraction subclass: #PrefContainer
	instanceVariableNames: ''
	classVariableNames: ''!

PrefInteraction subclass: #PrefControl
	instanceVariableNames: ''
	classVariableNames: ''!

PrefInteraction subclass: #PrefDialog
	instanceVariableNames: ''
	classVariableNames: ''!

PrefItemGroup subclass: #PrefDynamicList
	instanceVariableNames: ''
	classVariableNames: ''!

PrefDynamicList subclass: #PrefIniDynamicList
	instanceVariableNames: ''
	classVariableNames: ''!

PrefControl subclass: #PrefTimeDateControl
	instanceVariableNames: ''
	classVariableNames: ''!

PrefDynamicList subclass: #PrefTocList
	instanceVariableNames: ''
	classVariableNames: ''!

!Pref comment!
Library config, file config.goh! !

!Pref class methodsFor: 'library linkage'!

library
	^14!

entry
	^1!

level
	^8! !

!Pref methodsFor: 'Geos variant class'!

pref: aClass
	pref := aClass basicNew optr: optr.!

pref
	^pref!

setVariant
	self dwordAt: 0 put: pref class classPtr asInteger.!

doesNotUnderstand: aMessage
	^pref perform: aMessage selector withArguments: aMessage arguments!

!Pref methodsFor: 'Geos instance variables'!

piAttrs
	"@instance PrefAttributes PI_attrs"
	^self byteAt: 4!

piAttrs: value
	"@instance PrefAttributes PI_attrs"
	^self byteAt: 4 put: value!

!

!Pref methodsFor: 'Geos vardata'!

attrPrefRebootString: value
	"@vardata optr ATTR_PREF_REBOOT_STRING"
	^self addVardata: ##attrPrefRebootString dword: value!

attrPrefRequiredFeatures: value
	"@vardata PrefMgrFeatures ATTR_PREF_REQUIRED_FEATURES"
	^self addVardata: ##attrPrefRequiredFeatures word: value!

attrPrefProhibitedFeatures: value
	"@vardata PrefMgrFeatures ATTR_PREF_PROHIBITED_FEATURES"
	^self addVardata: ##attrPrefProhibitedFeatures word: value!

attrPrefMinLevel: value
	"@vardata UIInterfaceLevel ATTR_PREF_MIN_LEVEL"
	^self addVardata: ##attrPrefMinLevel word: value!

attrPrefMaxLevel: value
	"@vardata UIInterfaceLevel ATTR_PREF_MAX_LEVEL"
	^self addVardata: ##attrPrefMaxLevel word: value!

!

!Pref methodsFor: 'Geos messages'!

setInitFileCategory: category
	"@message void MSG_PREF_SET_INIT_FILE_CATEGORY(const char *category = cx:dx)"
	^self geosMessage: #[128 0 2 53 3 0] with: category!

hasStateChanged
	"@message Boolean MSG_PREF_HAS_STATE_CHANGED()= carry"
	^self geosMessage: #[128 1 2 0 4]!

getRebootInfo
	"@message optr MSG_PREF_GET_REBOOT_INFO()= cx:dx"
	^self geosMessage: #[128 2 154 0 2]!

getRebootString
	"@message optr MSG_PREF_GET_REBOOT_STRING()= cx:dx"
	^self geosMessage: #[128 3 154 0 2]!

init: features with: level
	"@message void MSG_PREF_INIT(PrefMgrFeatures features=cx, UIInterfaceLevel level=dx)"
	^self geosMessage: #[128 4 2 53 1 1 0] with: features with: level!

notifyDialogChange: type
	"@message void MSG_PREF_NOTIFY_DIALOG_CHANGE(PrefDialogChangeType type=cx)"
	^self geosMessage: #[128 5 2 5 1 0] with: type!

setOriginalState
	"@message void MSG_PREF_SET_ORIGINAL_STATE()"
	^self geosMessage: #[128 6 2 0 0]!

!

!PrefBooleanGroup comment!
Library config, file config.goh! !

!PrefBooleanGroup class methodsFor: 'library linkage'!

library
	^14!

entry
	^0!
!

!PrefBooleanGroup methodsFor: 'Geos instance variables'!

pbgiInitFileFlags
	"@instance PrefInitFileFlags PBGI_initFileFlags"
	^self byteAt: 5!

pbgiInitFileFlags: value
	"@instance PrefInitFileFlags PBGI_initFileFlags"
	^self byteAt: 5 put: value!

pbgiOriginalState
	"@instance word PBGI_originalState"
	^self wordAt: 6!

pbgiOriginalState: value
	"@instance word PBGI_originalState"
	^self wordAt: 6 put: value!

!

!PrefBooleanGroup methodsFor: 'Geos vardata'!

!

!PrefBooleanGroup methodsFor: 'Geos messages'!

booleanGroupSetOriginalState: state
	"@message void MSG_PREF_BOOLEAN_GROUP_SET_ORIGINAL_STATE(word state = cx)"
	^self geosMessage: #[136 0 2 5 1 0] with: state!

!

!PrefInteraction comment!
Library config, file config.goh! !

!PrefInteraction class methodsFor: 'library linkage'!

library
	^14!

entry
	^3!
!

!PrefInteraction methodsFor: 'Geos instance variables'!

piiAttrs
	"@instance PrefInteractionAttrs PII_attrs"
	^self byteAt: 5!

piiAttrs: value
	"@instance PrefInteractionAttrs PII_attrs"
	^self byteAt: 5 put: value!

!

!PrefInteraction methodsFor: 'Geos vardata'!

!

!PrefInteraction methodsFor: 'Geos messages'!

!

!PrefItemGroup comment!
Library config, file config.goh! !

!PrefItemGroup class methodsFor: 'library linkage'!

library
	^14!

entry
	^4!
!

!PrefItemGroup methodsFor: 'Geos instance variables'!

pigiInitFileFlags
	"@instance PrefInitFileFlags PIGI_initFileFlags"
	^self byteAt: 5!

pigiInitFileFlags: value
	"@instance PrefInitFileFlags PIGI_initFileFlags"
	^self byteAt: 5 put: value!

pigiOriginalSelection
	"@instance word PIGI_originalSelection"
	^self wordAt: 6!

pigiOriginalSelection: value
	"@instance word PIGI_originalSelection"
	^self wordAt: 6 put: value!

pigiOriginalNumSelections
	"@instance word PIGI_originalNumSelections"
	^self wordAt: 8!

pigiOriginalNumSelections: value
	"@instance word PIGI_originalNumSelections"
	^self wordAt: 8 put: value!

pigiSuspendCount
	"@instance byte PIGI_suspendCount"
	^self byteAt: 10!

pigiSuspendCount: value
	"@instance byte PIGI_suspendCount"
	^self byteAt: 10 put: value!

!

!PrefItemGroup methodsFor: 'Geos vardata'!

attrPrefItemGroupEnable
	"@vardata PrefEnableData ATTR_PREF_ITEM_GROUP_ENABLE"
	^self addVardata: ##attrPrefItemGroupEnable size: 5!

attrPrefItemGroupEnable: aBlock
	"@vardata PrefEnableData ATTR_PREF_ITEM_GROUP_ENABLE"
	aBlock value: (GCSPrefEnableData forPointer: (self addVardata: ##attrPrefItemGroupEnable size: 5)).!

attrPrefItemGroupOverride: value
	"@vardata word ATTR_PREF_ITEM_GROUP_OVERRIDE"
	^self addVardata: ##attrPrefItemGroupOverride word: value!

attrPrefItemGroupTextDisplay: value
	"@vardata ChunkHandle ATTR_PREF_ITEM_GROUP_TEXT_DISPLAY"
	^self addVardata: ##attrPrefItemGroupTextDisplay word: value!

attrPrefItemGroupStatusText: value
	"@vardata ChunkHandle ATTR_PREF_ITEM_GROUP_STATUS_TEXT"
	^self addVardata: ##attrPrefItemGroupStatusText word: value!

attrPrefItemGroupExtraStringSection
	"@vardata TCHAR[] ATTR_PREF_ITEM_GROUP_EXTRA_STRING_SECTION"
	^self addVardata: ##attrPrefItemGroupExtraStringSection size: 0!

!

!PrefItemGroup methodsFor: 'Geos messages'!

itemGroupSetOriginalSelection: selection
	"@message void MSG_PREF_ITEM_GROUP_SET_ORIGINAL_SELECTION(word selection=cx)"
	^self geosMessage: #[136 0 2 5 1 0] with: selection!

itemGroupGetSelectedItemText: buffer with: bufSize
	"@message word MSG_PREF_ITEM_GROUP_GET_SELECTED_ITEM_TEXT(char *buffer=cx:dx, word bufSize=bp)= bp"
	^self geosMessage: #[136 1 111 245 3 1 1] with: buffer with: bufSize!

itemGroupGetItemMoniker: buffer with: bufSize with: identifier
	"@message word MSG_PREF_ITEM_GROUP_GET_ITEM_MONIKER(@stack TCHAR *buffer, word bufSize, word identifier)= bp"
	^self geosMessage: #[136 2 108 8 3 1 1 1] with: buffer with: bufSize with: identifier!

itemGroupUpdateText: textObject
	"@message void MSG_PREF_ITEM_GROUP_UPDATE_TEXT(ChunkHandle textObject=cx)"
	^self geosMessage: #[136 3 2 5 1 0] with: textObject!

!

!PrefPortItem comment!
Library config, file config.goh! !

!PrefPortItem class methodsFor: 'library linkage'!

library
	^14!

entry
	^46!
!

!PrefPortItem methodsFor: 'Geos instance variables'!

ppiiPortMask
	"@instance word PPII_portMask"
	^self wordAt: 5!

ppiiPortMask: value
	"@instance word PPII_portMask"
	^self wordAt: 5 put: value!

ppiiType
	"@instance byte PPII_type"
	^self byteAt: 7!

ppiiType: value
	"@instance byte PPII_type"
	^self byteAt: 7 put: value!

ppiiStatus
	"@instance byte PPII_status"
	^self byteAt: 8!

ppiiStatus: value
	"@instance byte PPII_status"
	^self byteAt: 8 put: value!

!

!PrefPortItem methodsFor: 'Geos vardata'!

!

!PrefPortItem methodsFor: 'Geos messages'!

portItemGetStatus
	"@message word MSG_PREF_PORT_ITEM_GET_STATUS()"
	^self geosMessage: #[136 0 2 0 1]!

portItemFreeDriver
	"@message void MSG_PREF_PORT_ITEM_FREE_DRIVER()"
	^self geosMessage: #[136 1 2 0 0]!

!

!PrefStringItem comment!
Library config, file config.goh! !

!PrefStringItem class methodsFor: 'library linkage'!

library
	^14!

entry
	^6!
!

!PrefStringItem methodsFor: 'Geos instance variables'!

psiiInitFileString
	"@instance ChunkHandle PSII_initFileString"
	^self wordAt: 20!

psiiInitFileString: value
	"@instance ChunkHandle PSII_initFileString"
	^self wordAt: 20 put: value!

!

!PrefStringItem methodsFor: 'Geos vardata'!

!

!PrefStringItem methodsFor: 'Geos messages'!

stringItemSetInitFileString: str
	"@message void MSG_PREF_STRING_ITEM_SET_INIT_FILE_STRING(const char *str=cx:dx)"
	^self geosMessage: #[106 0 2 53 3 0] with: str!

stringItemCheckIfInInitFileKey: vars
	"@message Boolean MSG_PREF_STRING_ITEM_CHECK_IF_IN_INIT_FILE_KEY(PrefItemGroupStringVars *vars = ss:bp)= carry"
	^self geosMessage: #[106 1 0 128 3 4] with: vars!

!

!PrefText comment!
Library config, file config.goh! !

!PrefText class methodsFor: 'library linkage'!

library
	^14!

entry
	^10!
!

!PrefText methodsFor: 'Geos instance variables'!

ptiOriginalText
	"@instance ChunkHandle PTI_originalText"
	^self wordAt: 5!

ptiOriginalText: value
	"@instance ChunkHandle PTI_originalText"
	^self wordAt: 5 put: value!

!

!PrefText methodsFor: 'Geos vardata'!

attrPrefTextInitFileCategoryTarget: value
	"@vardata ChunkHandle ATTR_PREF_TEXT_INIT_FILE_CATEGORY_TARGET"
	^self addVardata: ##attrPrefTextInitFileCategoryTarget word: value!

!

!PrefText methodsFor: 'Geos messages'!

!

!PrefTrigger comment!
Library config, file config.goh! !

!PrefTrigger class methodsFor: 'library linkage'!

library
	^14!

entry
	^13!
!

!PrefTrigger methodsFor: 'Geos instance variables'!

!

!PrefTrigger methodsFor: 'Geos vardata'!

attrPrefTriggerAction
	"@vardata PrefTriggerAction ATTR_PREF_TRIGGER_ACTION"
	^self addVardata: ##attrPrefTriggerAction size: 6!

attrPrefTriggerAction: aBlock
	"@vardata PrefTriggerAction ATTR_PREF_TRIGGER_ACTION"
	aBlock value: (GCSPrefTriggerAction forPointer: (self addVardata: ##attrPrefTriggerAction size: 6)).!

!

!PrefTrigger methodsFor: 'Geos messages'!

!

!PrefValue comment!
Library config, file config.goh! !

!PrefValue class methodsFor: 'library linkage'!

library
	^14!

entry
	^7!
!

!PrefValue methodsFor: 'Geos instance variables'!

pviOriginalValue
	"@instance word PVI_originalValue"
	^self wordAt: 5!

pviOriginalValue: value
	"@instance word PVI_originalValue"
	^self wordAt: 5 put: value!

!

!PrefValue methodsFor: 'Geos vardata'!

attrPrefValueOrigIsIndeterminate
	"@vardata void ATTR_PREF_VALUE_ORIG_IS_INDETERMINATE"
	^self addVardata: ##attrPrefValueOrigIsIndeterminate!

attrPrefValueRound: value
	"@vardata word ATTR_PREF_VALUE_ROUND"
	^self addVardata: ##attrPrefValueRound word: value!

attrPrefValueWrap: value
	"@vardata word ATTR_PREF_VALUE_WRAP"
	^self addVardata: ##attrPrefValueWrap word: value!

!

!PrefValue methodsFor: 'Geos messages'!

valueSetOriginalValue: orig with: indeterminate
	"@message void MSG_PREF_VALUE_SET_ORIGINAL_VALUE(word orig=cx, Boolean indeterminate=bp)"
	^self geosMessage: #[136 0 2 61 1 4 0] with: orig with: indeterminate!

!

!TitledGlyph comment!
Library config, file config.goh! !

!TitledGlyph class methodsFor: 'library linkage'!

library
	^14!

entry
	^5!
!

!TitledGlyph methodsFor: 'Geos instance variables'!

!

!TitledGlyph methodsFor: 'Geos vardata'!

!

!TitledGlyph methodsFor: 'Geos messages'!

!

!PrefContainer comment!
Library config, file config.goh! !

!PrefContainer class methodsFor: 'library linkage'!

library
	^14!

entry
	^12!
!

!PrefContainer methodsFor: 'Geos instance variables'!

pciHandle
	"@instance word PCI_handle"
	^self wordAt: 6!

pciHandle: value
	"@instance word PCI_handle"
	^self wordAt: 6 put: value!

pciFileName
	"@instance FileLongName PCI_fileName"
	"#array #int8[36] [8, 36]"
	^self!

pciTemplateMon
	"@instance ChunkHandle PCI_templateMon"
	^self wordAt: 44!

pciTemplateMon: value
	"@instance ChunkHandle PCI_templateMon"
	^self wordAt: 44 put: value!

pciDupRoot
	"@instance dword PCI_dupRoot"
	^self dwordAt: 46!

pciDupRoot: value
	"@instance dword PCI_dupRoot"
	^self dwordAt: 46 put: value!

!

!PrefContainer methodsFor: 'Geos vardata'!

!

!PrefContainer methodsFor: 'Geos messages'!

closeHandle: fileOrLibHandle with: isLibrary
	"@message void MSG_PC_CLOSE_HANDLE(word fileOrLibHandle=cx, Boolean isLibrary = dx)"
	^self geosMessage: #[138 0 2 53 1 4 0] with: fileOrLibHandle with: isLibrary!

!

!PrefControl comment!
Library config, file config.goh! !

!PrefControl class methodsFor: 'library linkage'!

library
	^14!

entry
	^44!
!

!PrefControl methodsFor: 'Geos instance variables'!

!

!PrefControl methodsFor: 'Geos vardata'!

!

!PrefControl methodsFor: 'Geos messages'!

!

!PrefDialog comment!
Library config, file config.goh! !

!PrefDialog class methodsFor: 'library linkage'!

library
	^14!

entry
	^2!
!

!PrefDialog methodsFor: 'Geos instance variables'!

!

!PrefDialog methodsFor: 'Geos vardata'!

attrPrefDialogSysShutdownType: value
	"@vardata word ATTR_PREF_DIALOG_SYS_SHUTDOWN_TYPE"
	^self addVardata: ##attrPrefDialogSysShutdownType word: value!

!

!PrefDialog methodsFor: 'Geos messages'!

dialogReboot
	"@message void MSG_PREF_DIALOG_REBOOT()"
	^self geosMessage: #[138 0 2 0 0]!

dialogConfirmReboot: string
	"@message Boolean MSG_PREF_DIALOG_CONFIRM_REBOOT(optr string = cx:dx)= carry"
	^self geosMessage: #[138 1 2 53 2 4] with: string!

dialogRestartAck: restart
	"@message void MSG_PREF_DIALOG_RESTART_ACK(word restart=cx)"
	^self geosMessage: #[138 2 2 5 1 0] with: restart!

!

!PrefDynamicList comment!
Library config, file config.goh! !

!PrefDynamicList class methodsFor: 'library linkage'!

library
	^14!

entry
	^9!
!

!PrefDynamicList methodsFor: 'Geos instance variables'!

!

!PrefDynamicList methodsFor: 'Geos vardata'!

tempPdlKbdData
	"@vardata PDLKbdData TEMP_PDL_KBD_DATA"
	^self addVardata: ##tempPdlKbdData size: 38!

tempPdlKbdData: aBlock
	"@vardata PDLKbdData TEMP_PDL_KBD_DATA"
	aBlock value: (GCSPDLKbdData forPointer: (self addVardata: ##tempPdlKbdData size: 38)).!

!

!PrefDynamicList methodsFor: 'Geos messages'!

dynamicListBuildArray
	"@message void MSG_PREF_DYNAMIC_LIST_BUILD_ARRAY()"
	^self geosMessage: #[138 0 2 0 0]!

dynamicListFindItem: itemPtr with: str with: ignoreCase
	"@message Boolean MSG_PREF_DYNAMIC_LIST_FIND_ITEM(word *itemPtr = multipleax, const char *str = cx:dx, Boolean ignoreCase = bp)= carry"
	^self geosMessage: #[138 1 215 245 3 3 4 4] with: itemPtr with: str with: ignoreCase!

dynamicListTimer
	"@message void MSG_PREF_DYNAMIC_LIST_TIMER()"
	^self geosMessage: #[138 2 2 0 0]!

!

!PrefIniDynamicList comment!
Library config, file config.goh! !

!PrefIniDynamicList class methodsFor: 'library linkage'!

library
	^14!

entry
	^48!
!

!PrefIniDynamicList methodsFor: 'Geos instance variables'!

pidliArray
	"@instance optr PIDLI_array"
	^self dwordAt: 11!

pidliArray: value
	"@instance optr PIDLI_array"
	^self dwordAt: 11 put: value!

!

!PrefIniDynamicList methodsFor: 'Geos vardata'!

attrPrefIniInitFileListCategory
	"@vardata TCHAR[] ATTR_PREF_INI_INIT_FILE_LIST_CATEGORY"
	^self addVardata: ##attrPrefIniInitFileListCategory size: 0!

attrPrefIniInitFileListKey
	"@vardata TCHAR[] ATTR_PREF_INI_INIT_FILE_LIST_KEY"
	^self addVardata: ##attrPrefIniInitFileListKey size: 0!

!

!PrefIniDynamicList methodsFor: 'Geos messages'!

!

!PrefTimeDateControl comment!
Library config, file config.goh! !

!PrefTimeDateControl class methodsFor: 'library linkage'!

library
	^14!

entry
	^45!
!

!PrefTimeDateControl methodsFor: 'Geos instance variables'!

ptdciTimer
	"@instance dword PTDCI_timer"
	^self dwordAt: 6!

ptdciTimer: value
	"@instance dword PTDCI_timer"
	^self dwordAt: 6 put: value!

ptdciMaxDays
	"@instance byte PTDCI_maxDays"
	^self byteAt: 10!

ptdciMaxDays: value
	"@instance byte PTDCI_maxDays"
	^self byteAt: 10 put: value!

ptdciMonth
	"@instance byte PTDCI_month"
	^self byteAt: 11!

ptdciMonth: value
	"@instance byte PTDCI_month"
	^self byteAt: 11 put: value!

ptdciYear
	"@instance word PTDCI_year"
	^self wordAt: 12!

ptdciYear: value
	"@instance word PTDCI_year"
	^self wordAt: 12 put: value!

!

!PrefTimeDateControl methodsFor: 'Geos vardata'!

!

!PrefTimeDateControl methodsFor: 'Geos messages'!

timerTick
	"@message void MSG_PTDC_TIMER_TICK()"
	^self geosMessage: #[140 0 2 0 0]!

monthChange
	"@message void MSG_PTDC_MONTH_CHANGE()"
	^self geosMessage: #[140 1 2 0 0]!

yearChange
	"@message void MSG_PTDC_YEAR_CHANGE()"
	^self geosMessage: #[140 2 2 0 0]!

setTime
	"@message void MSG_PTDC_SET_TIME()"
	^self geosMessage: #[140 3 2 0 0]!

setDate
	"@message void MSG_PTDC_SET_DATE()"
	^self geosMessage: #[140 4 2 0 0]!

!

!PrefTocList comment!
Library config, file config.goh! !

!PrefTocList class methodsFor: 'library linkage'!

library
	^14!

entry
	^11!
!

!PrefTocList methodsFor: 'Geos instance variables'!

ptliFlags
	"@instance TocUpdateCategoryFlags PTLI_flags"
	^self wordAt: 11!

ptliFlags: value
	"@instance TocUpdateCategoryFlags PTLI_flags"
	^self wordAt: 11 put: value!

ptliTocInfo
	"@instance TocCategoryStruct PTLI_tocInfo"
	^GCSTocCategoryStruct forPointer: (self ptrAt: 13).!

ptliTocInfo: aBlock
	"@instance TocCategoryStruct PTLI_tocInfo"
	aBlock value: (GCSTocCategoryStruct forPointer: (self ptrAt: 13)).!

!

!PrefTocList methodsFor: 'Geos vardata'!

attrPrefTocListExtraEntry_1
	"@vardata PrefTocExtraEntry ATTR_PREF_TOC_LIST_EXTRA_ENTRY_1"
	^self addVardata: ##attrPrefTocListExtraEntry_1 size: 6!

attrPrefTocListExtraEntry_1: aBlock
	"@vardata PrefTocExtraEntry ATTR_PREF_TOC_LIST_EXTRA_ENTRY_1"
	aBlock value: (GCSPrefTocExtraEntry forPointer: (self addVardata: ##attrPrefTocListExtraEntry_1 size: 6)).!

attrPrefTocListExtraEntry_2
	"@vardata PrefTocExtraEntry ATTR_PREF_TOC_LIST_EXTRA_ENTRY_2"
	^self addVardata: ##attrPrefTocListExtraEntry_2 size: 6!

attrPrefTocListExtraEntry_2: aBlock
	"@vardata PrefTocExtraEntry ATTR_PREF_TOC_LIST_EXTRA_ENTRY_2"
	aBlock value: (GCSPrefTocExtraEntry forPointer: (self addVardata: ##attrPrefTocListExtraEntry_2 size: 6)).!

attrPrefTocListInfoKey
	"@vardata char[] ATTR_PREF_TOC_LIST_INFO_KEY"
	^self addVardata: ##attrPrefTocListInfoKey size: 0!

attrPrefTocListContainer: value
	"@vardata optr ATTR_PREF_TOC_LIST_CONTAINER"
	^self addVardata: ##attrPrefTocListContainer dword: value!

!

!PrefTocList methodsFor: 'Geos messages'!

tocListGetSelectedItemInfo: infoPtr
	"@message Boolean MSG_PREF_TOC_LIST_GET_SELECTED_ITEM_INFO(word *infoPtr = multipleax)= carry"
	^self geosMessage: #[140 0 214 0 3 4] with: infoPtr!

tocListGetSelectedDriverName: buf with: bufSize
	"@message word MSG_PREF_TOC_LIST_GET_SELECTED_DRIVER_NAME(char *buf = cx:dx, word bufSize = bp)= bp"
	^self geosMessage: #[140 1 111 245 3 1 1] with: buf with: bufSize!

tocListGetSelectedItemPath: retValue
	"@message void MSG_PREF_TOC_LIST_GET_SELECTED_ITEM_PATH(TocItemPath *retValue = bpaxdxcx)"
	^self geosMessage: #[140 2 210 0 3 0] with: retValue!

tocListCheckDeviceAvailable: retvalPtr
	"@message Boolean MSG_PREF_TOC_LIST_CHECK_DEVICE_AVAILABLE(word *retvalPtr = multipleax)= carry"
	^self geosMessage: #[140 3 214 0 3 4] with: retvalPtr!

tocListSetTokenChars: chars
	"@message void MSG_PREF_TOC_LIST_SET_TOKEN_CHARS(TokenChars *chars = ss:bp)"
	^self geosMessage: #[140 4 0 128 3 0] with: chars!

!

